@extends('layouts.app')
@section('content')
    <div class="container">
        <div class="clearfix"></div>
        @include('adminlte-templates::common.errors')
        @include('flash::message')
        <div class="card ">
            <div class="card-header">
                <h4 class="card-title">Editar permisos de {{ $model->nombre_rol }} </h4>
            </div>

            {!! Form::model($model, ['route' => ['roles.update', $model->id_rol], 'method' => 'patch']) !!}

            <div class="card">
                <br>
                <div class='col-sm-6'>
                    {!! Form::label('filtrarformulario', 'Filtrar Formulario:') !!}
                    <input class="form-control" id="myInput" type="text"
                        placeholder="Ingresa nombre formulario a filtrar..">
                    <br>
                    @push('scripts')
                        <script>
                            $(document).ready(function() {
                                $("#myInput").on("keyup", function() {
                                    var value = $(this).val().toLowerCase();
                                    $("#myTable tr").filter(function() {
                                        $(this).toggle($(this).text().toLowerCase().indexOf(value) > -1)
                                    });
                                });
                            });
                        </script>
                    @endpush
                </div>
                <div class="table-responsive">
                    <table class="table item-table" id="tpermisos">
                        <thead class="table">
                            <tr>
                                <th hidden>id_rol_permiso</th>
                                <th>Formulario</th>
                                <th>Listar</th>
                                <th>Crear</th>
                                <th>Editar</th>
                                <th>Visualizar</th>
                                <th>Imprimir</th>
                                <th>Exportar</th>
                                <th>Asignar</th>
                                <th>Calificar</th>
                                <th>Derivar</th>
                                <th>Fiscalizar</th>
                            </tr>
                        </thead>
                        <tbody id="myTable">
                            @foreach ($rolpermisos as $key => $rolpermisos)
                                <tr>
                                    <td hidden width="1%">
                                        {!! Form::hidden('id_formulario', $rolpermisos->id_formulario, ['name' => 'permi[' . $rolpermisos->id_rol_permiso . '][id_formulario]']) !!}
                                        {{-- {!! $rolpermisos->id_rol_permiso !!} --}}
                                    </td>
                                    <td width="10%">
                                        {!! $rolpermisos->formulario->nombre_formulario !!}
                                    </td>
                                    <td width="5%">
                                        {!! Form::checkbox('listar', '1', $rolpermisos->listar, ['name' => 'permi[' . $rolpermisos->id_rol_permiso . '][listar]']) !!}
                                    </td>
                                    <td width="5%">
                                        {!! Form::checkbox('crear', '1', $rolpermisos->crear, ['name' => 'permi[' . $rolpermisos->id_rol_permiso . '][crear]']) !!}
                                    </td>
                                    <td width="5%">
                                        {!! Form::checkbox('editar', '1', $rolpermisos->editar, ['name' => 'permi[' . $rolpermisos->id_rol_permiso . '][editar]']) !!}
                                    </td>
                                    <td width="5%">
                                        {!! Form::checkbox('visualizar', '1', $rolpermisos->visualizar, ['name' => 'permi[' . $rolpermisos->id_rol_permiso . '][visualizar]']) !!}
                                    </td>
                                    <td width="5%">
                                        {!! Form::checkbox('imprimir', '1', $rolpermisos->imprimir, ['name' => 'permi[' . $rolpermisos->id_rol_permiso . '][imprimir]']) !!}
                                    </td>
                                    <td width="5%">
                                        {!! Form::checkbox('exportar', '1', $rolpermisos->exportar, ['name' => 'permi[' . $rolpermisos->id_rol_permiso . '][exportar]']) !!}
                                    </td>
                                    <td width="5%">
                                        {!! Form::checkbox('asignar', '1', $rolpermisos->asignar, ['name' => 'permi[' . $rolpermisos->id_rol_permiso . '][asignar]']) !!}
                                    </td>
                                    <td width="5%">
                                        {!! Form::checkbox('calificar', '1', $rolpermisos->calificar, ['name' => 'permi[' . $rolpermisos->id_rol_permiso . '][calificar]']) !!}
                                    </td>
                                    <td width="5%">
                                        {!! Form::checkbox('derivar', '1', $rolpermisos->derivar, ['name' => 'permi[' . $rolpermisos->id_rol_permiso . '][derivar]']) !!}
                                    </td>
                                    <td width="5%">
                                        {!! Form::checkbox('fiscalizar', '1', $rolpermisos->fiscalizar, ['name' => 'permi[' . $rolpermisos->id_rol_permiso . '][fiscalizar]']) !!}
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            </div>

            <!-- Campos ocultos que se envian -->
            <div class="form-group col-sm-6">
                {!! Form::hidden('id_usuario_modifico', auth()->user()->id_usuario) !!}
                {!! Form::hidden('id_rol', $model->id_rol) !!}
                {!! Form::hidden('id_rol_rolpermisos', $rolpermisos->id_rol_permiso) !!}
                {!! Form::hidden('updatepermiso', true) !!}

            </div>

            <!-- Submit Field -->
            <div class="form-group col-sm-12">
                <div class="row float-right">
                    {!! Form::submit('Guardar', ['class' => 'btn btn2']) !!}
                    <a href="{{ URL::previous() }}" class="btn btn1 ml-1">Cancelar</a>
                    {{-- <a href="{{ route('roles.index') }}" class="btn btn1 ml-1">Cancelar</a> --}}
                </div>
            </div>
            {!! Form::close() !!}

        </div>
    </div>
@endsection
